//%attributes = {}
// Method: pr_ AmountDesign1ToStock1( amountToConvert:R ; multiplier:R; round:L)
// 2003.04.17-16:10:59 / Pasi Mankinen
// © Copyright 2003 Manage Applications
// Purpose: Converts amount from design unit 1 to stock unit 1
// 
// ------------------------------------------------------------
C_REAL:C285($0; $1; $2)
C_LONGINT:C283($3; $pr_lRound)  //round value to default decimals
C_REAL:C285($pr_rStock1Amount; $pr_rDesign1Amount; $pr_rMultiplier)

$pr_rDesign1Amount:=$1
$pr_rMultiplier:=$2
$pr_lRound:=$3

If ($pr_rMultiplier=kGet)  //-10022
	If (_rec Loaded(pr_kTbl)=kFalse)
		_err MESSAGE(_lang Current("Product record is not loaded, conversion multiplier can not be loaded"); Current method name:C684; kTrue)
	Else 
		$pr_rMultiplier:=_fld ValueReal(pr_kUnit__Design_Unit_Multip)
	End if 
End if 

If ($pr_rMultiplier#-1)
	$pr_rStock1Amount:=$pr_rDesign1Amount*$pr_rMultiplier
Else 
	If ($pr_rDesign1Amount#0)
		$pr_rStock1Amount:=1/$pr_rDesign1Amount
	Else 
		$pr_rStock1Amount:=0
	End if 
End if 
If ($pr_lRound=kTrue)
	$pr_rStock1Amount:=Round:C94($pr_rStock1Amount; <>pr_iPyörMäär)
End if 
$0:=$pr_rStock1Amount
